String fileName = "tree.jpg";                        // The name of the original image file.
PImage sector;                                       // This PImage is used for the sprite
int radius;                                          // Radius of the sector.
int screenWidth;                                     // Width of the display area.

void settings()
{
   sector = loadImage(fileName);                      // Get the image that will be cropped for the sector
   radius = sector.width;
   if(sector.height != radius)                        // Check that the original image is square.
   {
       println("Error - image not square");
   }
   size(radius, radius);                              // Set up the display area.
}

void setup()
{
    sector.loadPixels();                              // Load its pixels;
    background(128);                                  // Make the display background gray.
    image(sector, 0, 0);                              // Place the sector in the display area.
}

void draw()                                           // Although this routine is not used,
{                                                     // it cannot be omitted.
}

void makeSector()                                     // This routine does the cropping
{
   color transparent = color(255, 255, 255, 1);       // Transparent pixel color
   int k;
   float x, y;                                        // Natural (mathematical) coordinates
   x = -radius/2 + 0.5;                               // x runs from -radius/2 + 0.5 to radius/2 - 0.5
   for(int j = 0; j < radius; j = j + 1)              // For each column (x-coordinate)   
   {
      y = 0.5;                                        // y runs from 0.5 to radius - 0.5
      for(int i = 0; i < radius; i = i + 1)       
      {
         k = (radius - 1 - i) * radius + j;           // Index for this pixel based on unnatural coordinates.
         if(x * x + y * y > radius * radius)          // Make pixels outside circle transparent.
         {
            sector.pixels[k] = transparent;
         }
         if(y <= sqrt(3) * abs(x))
         {
            sector.pixels[k] = transparent;          // Make pixels outside wedge transparent.
         }
         y = y + 1;                                  // Next column (x-coordinate).
      }
      x = x + 1;                                     // Next row (y-coordinate).
   }
   sector.updatePixels();                            // Update the pixels.
}

void mouseClicked()                                   // Show cropped sector when mouse is clicked.
{
   makeSector();                                      // This routine does the cropping.
   background(128);                                   // Make the display background gray.
   image(sector, 0, 0);                               // Place the sector in the display area.
   save("result.jpg");                                // Save the result as a .jpg
}
