String fileName = "sample.jpg";     // The name of the image file.

int width, height;                  // The width and height of the image.
PImage photo;                       // PImage is an object that contains the information for an image.

void settings()                     // This routine runs once, before the setup routine.
{
  photo = loadImage(fileName);      // This loads the file as an image.
  width = photo.width;              // The width of the image.
  height = photo.height;            // The height of the image.
  size(width, height);              // This line sets the width and height of the display area.
}


void setup()                        // The setup routine is run once after the settings routine.
{
  image(photo, 0, 0);               // This displays the iamge in the graphics display area. 
}

void draw()                         // The draw routine is run once for each frame of an animation.
{                                   // This one does nothing but the routine should not be omitted.
}

void mouseClicked()              // The mouseClicked routine is run each time the user clicks the mouse 
{                                // This routine is only needed to respond to mouse clicks.
  color pixel;                   // Used for pixel information.
  print("You clicked at x = ");  // These lines print to the console below.
  print(mouseX);                 // mouseX and mouseY are the mouse coordinates.
  print(" y = ");                // The print function prints to the console without a carriage return.
  print(mouseY);                 // The println function prints to the console with a carriage return.
  pixel = photo.pixels[mouseY * width + mouseX];   // Get pixel color at point.
  print("  red = ");             // Print the RGB values for this pixel.
  print(red(pixel));
  print("   green = ");
  print(green(pixel));
  print("   blue = ");
  println(blue(pixel));
}
