float radius = 10;            // Radius of circular mirror.

float eyeX = -1.0;            // The x-coordinate of the eye
float eyeY = 5;               // The y-coordinate of the eye

float targetX = 1.0;          // The x-coordinate of the target
float targetY = 5;            // The y-coordinate of the target

float a = -5;                 // The left end of the interval
float b = 5;                  // The right end of the interval

float yLow;                   // The lowest value of y for the 21 sample points
float yHigh;                  // The highest value of y for the 21 sample points

float mirror(float x)         // y-coordinate on mirror for a point
{
   return sqrt(radius * radius - x * x); 
}

float fcn(float x)
{
   float eyeToMirror    = sqrt((eyeX - x) * (eyeX - x)       + (eyeY - mirror(x)) * (eyeY - mirror(x)));          // Distance from eye to mirror
   float targetToMirror = sqrt((targetX - x) * (targetX - x) + (targetY - mirror(x)) * (targetY - mirror(x)));    // Distance from target to mirror
   return eyeToMirror + targetToMirror;                                                                           // Return the total path length
}

void settings()               // This routine runs once, before the setup routine
{
  size(821, 421);
}

void setup()                  // The setup routine is run once when the program (sketch )starts
{
   plot21();                  // Plot 21 points in the interval
}

void draw()                   // The draw routine is not used but it is necessary
{  
}

void plot21()
{
   float x, y, xLowest, xHighest;                    // Used for computations
   background(255);                                  // Clear display area to all white
   stroke(128, 128, 255);                            // Grid lines are green
   for(int i = 0; i <= 20; i = i + 1)                // Draw vertical grid lines
   {
      line(10 + i * 40, 10, 10 + i * 40, 410); 
   }
   for(int i = 0; i <= 10; i = i + 1)                // Draw horizontal grid lines
   {
      line(10, 10 + i * 40, 810, 10 + i * 40); 
   }
   yLow = fcn(a);
   xLowest = a;
   yHigh = fcn(a);
   xHighest = a;
   for(int i = 1; i <= 20; i = i + 1)                // Find the minimum and maximum values of y for the 21 sample points
   {
     x = a + i * 0.05 * (b - a);                     // x-value of this sample point
     y = fcn(x);                                     // y-value of this sample point
     if(y < yLow)                                    // Check if this sample point is below the previous lowest sample point
     {
        yLow = y;
        xLowest = x;
     }
     if(y > yHigh)                                   // Check if this sample point is above the previous highest sample point
     {
        yHigh = y;
        xHighest = x;
     }
   }
   print("The lowest y value for the 21 sample points is ");
   print(yLow);
   print(" at x = ");
   println(xLowest);
   print("The highest y value for the 21 sample points is ");
   print(yHigh);
   print(" at x = ");
   println(xHighest);
   println("");
   stroke(0);                                        // The dots at the samplepoints are black
   fill(0);
   for(int i = 0; i <= 20; i = i + 1)                // Plot sample points
   {
     x = a + i * 0.05 * (b - a);                     // x-value of this sample point
     y = fcn(x);                                     // y-value of this sample point
     circle(xOf(x), yOf(y), 8);
   }
}

void mousePressed()
{
   float dx = (b - a)/20.0;                          // x-interval width
   int x = round((mouseX - 10.0)/40);
   a = a + (x - 1) * dx;
   b = a + 2 * dx;
   plot21();
}

int xOf(float x)
{
   return round(10 + 800 * (x - a)/(b - a));               // Return the display area x-coordinate of a point whose math coordinate is x 
}

int yOf(float y)
{
   return round(410 - 400 * (y - yLow)/(yHigh - yLow));    //  Return the display area y-coordinate of a point whose math coordinate is y
}
