float a = 0;                  // The lowest possible value of x.  
float b = 800;                // The highest possible value of x.
float yLow;                   // The lowest possible value of y.  Computed in setup.
float yHigh;                  // The highest possible value of y.  Computed in setp.

float fcn(float x)            // The function to be minimized.
{
   return sqrt(pow(x, 2) + pow(200, 2))/30.0 + sqrt(pow(800 - x, 2) + pow(200, 2))/22.5; 
}

void settings()               // This routine runs once, before the setup routine.
{
  size(601, 401);
}

void setup()                  // The setup routine is run once when the program (sketch )starts.
{
  float dx = (b - a)/100;
  float x, y, newX, newY;
  //
  // The next lines find the minimum and maximum possible values of y
  //
  yHigh = fcn(a);
  yLow = fcn(a);
  for(int i = 0; i <= 100; i = i + 1)
  {
    x = a + i * dx;
    yHigh= max(yHigh, fcn(x));
    yLow = min(yLow,fcn(x));
  }
  //
  //  The next lines draw a very rough graph of the function to be minimized.
  //
  background(255);
  x = a;
  y = fcn(a);
  for(int i = 0; i < 100; i = i + 1)
  {
    newX = x + dx;
    newY = fcn(newX);
    line(xScale(x), yScale(y), xScale(newX), yScale(newY));
    x = newX;
    y = newY;
  }
  //
  //   The next lines estimate the minimum value of the function and the corresponding value of x.
  //
  for(int i = 0; i < 8; i = i + 1)     // Use the narrow routine to narrow the interval 8 times.
  {
      narrow();
  }
  print("The fastest path is when x = ");
  println((a + b)/2);
}

void draw()                            // The draw routine is run once for each frame of an animation.
{                                      // This one does nothing but the routine should not be omitted
}

int xScale(float x)                    // This function transforms x values to screen x-coordinates.
{
   return round((x - a) * 600 /(b - a));  
}

int yScale(float y)                    // This function transforms y values to screen y-coordinates.
{
   return  400 - round((y - yLow) * 400/(yHigh - yLow));
}

void narrow()                          // This is the workhorse for minimzing the function.
{
   float dx = (b - a)/20;              // It looks at 21 points in an interval
   float yMin = fcn(a);                // and finds the minimum value of y for those 21 points.
   float xMin = a;
   float x = a;
   for(int i = 0; i < 20; i = i + 1)
   {
      x = x + dx;
      if(fcn(x) < yMin)
      {
        yMin = fcn(x);
        xMin = x;
      }
   }
   a = xMin - dx;                      // Then it narrows the interval by a factor of ten
   b = xMin + dx;                      // including from just left to just right of the found minimum.
}
