// This program is designed for images that are 800 pixels wide and 533 pixels high.
// For different sizes change lines 4 and 5.

int width = 800;                    // The width of the image.
int height = 533;                   // Then height of the image.
PImage photo;                       // PImage is an object that contains the information for an image.

void settings()                     // This routine runs once, before the setup routine.
{
  size(width, height);              // This line sets the width and height of the display area.
}


void setup()                        // The setup routine is runs once after the settings routine.
{
  photo = loadImage("sample.jpg");  // This loads the file "sample.jpg" as an image.
  image(photo, 0, 0);               // This displays the iamge in the graphics display area. 
}

void draw()                         // The draw routine is run once for each frame of an animation.
{                                   // This one does nothing but the routine should not be omitted.
}

void mouseClicked()              // The mouseClicked routine is run each time the user clicks the mouse 
{                                // This routine is only needed to respond to mouse clicks.
  color pixel;                   // Used for pixel information.
  print("You clicked at x = ");  // These lines print to the console below.
  print(mouseX);                 // mouseX and mouseY are the mouse coordinates.
  print(" y = ");                // The print function prints to the console without a carriage return.
  print(mouseY);                 // The println function prints to the console with a carriage return.
  pixel = photo.pixels[mouseY * width + mouseX];   // Get pixel color at point.
  print("  red = ");             // Print the RGB values for this pixel.
  print(red(pixel));
  print("   green = ");
  print(green(pixel));
  print("   blue = ");
  println(blue(pixel));
}
